<?php
include('vendor/autoload.php');
use Jajo\JSONDB;

function m18_busca_video($videoID = false){
    $json_db = new JSONDB(PASTA_DATA);
    
    $deletado = false;
    $mp4   = '';
    $hls   = '';
    $thumb = '';

    if (empty(PROXY_LOGIN)) {
        $deletado = true;
    }else{
        
        //deleta os arquivos de video antigos
        if ($handle = opendir(PASTA_CACHE)) {
            while (false !== ($file = readdir($handle))) {
                if (preg_match('/\.txt$/i', $file)) {
                    if ((time() - filemtime(PASTA_CACHE . $file)) > 7200) {  
                        unlink(PASTA_CACHE . $file);
                    }
                }
            }
        }

        //arquvio TXT existe?
        $cache = PASTA_CACHE . $videoID . '.txt';
        $existe_cache = m18_cache($cache);
        if($existe_cache){
            //m18_conta_acesso(@getallheaders()['M18-Site'],'existe');
            return $existe_cache;
        }

        //monta header
        $agente = "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:7.0.1) Gecko/20100101 Firefox/7.0.12011-10-16 20:23:00";

        $header = array();
        $header[0] = "Accept: text/xml,application/xml,application/xhtml+xml,";
        $header[0] .= "text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5";
        $header[] = "Cache-Control: max-age=0";
        $header[] = "Connection: keep-alive";
        $header[] = "Keep-Alive: 300";
        $header[] = "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7";
        $header[] = "Accept-Language: en-us,en;q=0.5";
        $header[] = "Pragma: ";

        if (!empty(PROXY_LINK)){
            $proxTempo = @file_get_contents(PASTA_DATA . 'cache_tempo.txt');
            if (empty($proxTempo) || (strtotime('now') > $proxTempo) || isset($_GET['atualiza'])) {
                file_put_contents(PASTA_DATA . 'cache_tempo.txt', strtotime('+120 minutes'));
                m18_busca_novo_proxy();

                /* Usa o proxy da lista */
                $total = 0;

                $proxys = $json_db->select('proxyValor, proxyAplicacoes')
                    ->from( 'proxy.json' )
                    ->where( [ 'proxyStatus' => 1, 'proxyFila' => 1 ], 'AND')
                    ->get();
                $total = COUNT($proxys);

                if ($total == 0) {
                    $json_db->update( [ 'proxyFila' => 1] )
                        ->from( 'proxy.json' )
                        ->where( [ 'proxyStatus' => 1] )
                        ->trigger();

                    $proxys = $json_db->select('proxyValor, proxyAplicacoes')
                        ->from( 'proxy.json' )
                        ->where( [ 'proxyStatus' => 1, 'proxyFila' => 1 ], 'AND')
                        ->get();
                }

                if($proxys){
                    $posicao = 1;
                    foreach ($proxys as $key => $itemValor) {
                        $proxyIP = $itemValor['proxyValor'];
                        $proxyAplicacoes = $itemValor['proxyAplicacoes'];

                        $link = 'https://www.xvideos.com/embedframe/'. $videoID;
                        
                        $curl = curl_init();
                        curl_setopt($curl, CURLOPT_URL, $link);
                        curl_setopt($curl, CURLOPT_USERAGENT, $agente);
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
                        curl_setopt($curl, CURLOPT_REFERER, $link);
                        curl_setopt($curl, CURLOPT_PROXY, $proxyIP);
                        curl_setopt($curl, CURLOPT_PROXYUSERPWD, PROXY_LOGIN .':'. PROXY_SENHA);
                        curl_setopt($curl, CURLOPT_ENCODING, "gzip,deflate");
                        curl_setopt($curl, CURLOPT_AUTOREFERER, true);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                        curl_setopt($curl, CURLOPT_TIMEOUT, 30);
                        curl_setopt($curl, CURLOPT_FOLLOWLOCATION,true);
                        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
                        $str = curl_exec($curl);
                        curl_close($curl);

                        $deletado = false;

                        if (empty($str)) {
                            $deletado = true;
                        }else{

                            $mp4 = '';
                            preg_match('/setVideoUrlHigh\(\'(.*?)\'\)/', $str, $match);
                            if (isset($match[1]))
                                $mp4 = $match[1];
                                
                            if (empty($mp4)) {
                                preg_match('/setVideoUrlLow\(\'(.*?)\'\)/', $str, $match);
                                if (isset($match[1]))
                                    $mp4 = $match[1];
                            }

                            $hls = '';    
                            preg_match('/html5player.setVideoHLS\(\'(.*?)\'\)/', $str, $match);
                            if (isset($match[1]))
                                $hls = $match[1];

                            $thumb = '';
                            preg_match('/setThumbUrl169\(\'(.*?)\'\)/', $str, $thumb);
                            if(isset($thumb[1])){
                                $thumb = str_replace('thumbslll', 'thumbs169lll', $thumb[1]);
                            }else{
                                preg_match('/setThumbUrl\(\'(.*?)\'\)/', $str, $thumb);
                                $thumb = isset($thumb[1]) ? str_replace('thumbslll', 'thumbs169lll', $thumb[1]) : '';
                            }

                            $title = '';    
                            preg_match('/html5player.setVideoTitle\(\'(.*?)\'\)/', $str, $match);
                            if (isset($match[1]))
                                $title = $match[1];

                            $autor = '';    
                            preg_match('/html5player.setUploaderName\(\'(.*?)\'\)/', $str, $match);
                            if (isset($match[1]))
                                $autor = $match[1];
                            
                            if (preg_match('/video has been deleted|Recebemos um pedido para que este|It has been automatically disabled|Sorry but the page you requested was not found|XVIDEOS.RED/', $str))
                                $deletado = true;
                        }

                        if ($deletado) {
                            $json_db->update( ['proxyStatus' => 2] )
                                ->from( 'proxy.json' )
                                ->where( [ 'proxyValor' => $proxyIP])
                                ->trigger();
                            break;
                        }

                        if (!empty($hls)) {
                            $proxyAplicacoes = $proxyAplicacoes + 1;

                            $json_db->update( ['proxyAplicacoes' => $proxyAplicacoes, 'proxyFila' => 2] )
                                ->from( 'proxy.json' )
                                ->where( [ 'proxyValor' => $proxyIP])
                                ->trigger();
                            break;
                        }

                        if ($posicao == 5)
                            break;

                        $posicao++;
                    }
                }
            }
        }

        if (empty($hls)) {
            $link = 'https://www.xvideos.com/embedframe/'. $videoID;

            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, $link);
            curl_setopt($curl, CURLOPT_USERAGENT, $agente);
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
            curl_setopt($curl, CURLOPT_REFERER, $link);
            curl_setopt($curl, CURLOPT_PROXY, PROXY_HOST);
            curl_setopt($curl, CURLOPT_PROXYUSERPWD, PROXY_LOGIN .':'. PROXY_SENHA);
            curl_setopt($curl, CURLOPT_ENCODING, "gzip,deflate");
            curl_setopt($curl, CURLOPT_AUTOREFERER, true);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl, CURLOPT_TIMEOUT, 30);
            curl_setopt($curl, CURLOPT_FOLLOWLOCATION,true);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

            $str = curl_exec($curl);

            curl_close($curl);

            $mp4 = '';
            preg_match('/setVideoUrlHigh\(\'(.*?)\'\)/', $str, $match);
            if (isset($match[1]))
                $mp4 = $match[1];
                
            if (empty($mp4)) {
                preg_match('/setVideoUrlLow\(\'(.*?)\'\)/', $str, $match);
                if (isset($match[1]))
                    $mp4 = $match[1];
            }

            $hls = '';    
            preg_match('/html5player.setVideoHLS\(\'(.*?)\'\)/', $str, $match);
            if (isset($match[1]))
                $hls = $match[1];

            $thumb = '';
            preg_match('/setThumbUrl169\(\'(.*?)\'\)/', $str, $thumb);
            if(isset($thumb[1])){
                $thumb = str_replace('thumbslll', 'thumbs169lll', $thumb[1]);
            }else{
                preg_match('/setThumbUrl\(\'(.*?)\'\)/', $str, $thumb);
                $thumb = isset($thumb[1]) ? str_replace('thumbslll', 'thumbs169lll', $thumb[1]) : '';
            }

            $title = '';    
            preg_match('/html5player.setVideoTitle\(\'(.*?)\'\)/', $str, $match);
            if (isset($match[1]))
                $title = $match[1];

            $autor = '';    
            preg_match('/html5player.setUploaderName\(\'(.*?)\'\)/', $str, $match);
            if (isset($match[1]))
                $autor = $match[1];
            
            if (preg_match('/video has been deleted|Recebemos um pedido para que este|It has been automatically disabled|Sorry but the page you requested was not found|XVIDEOS.RED/', $str))
                $deletado = true;
        }

        if (!empty($hls)) {
            $data = array(
                'thumb'    => str_replace('http://', 'https://', $thumb),
                'mp4'      => str_replace('http://', 'https://', $mp4),
                'hls'      => str_replace('http://', 'https://', $hls),
                'title'    => $title,
                'autor'    => $autor,
                'tempo'    => strtotime('+2 hours')
            );

            $retorno = file_put_contents($cache, json_encode($data));
        }
    }

    if($deletado){
        $arquivos = glob(PASTA_CACHE ."*.txt");
        $cache = @array_values($arquivos)[0];
        $last = m18_cache($cache);
        if($last)
            return $last;
    }

    //m18_conta_acesso(@getallheaders()['M18-Site'],'novo');

    return array(
        'thumb'    => str_replace('http://', 'https://', $thumb),
        'mp4'      => str_replace('http://', 'https://', $mp4),
        'hls'      => str_replace('http://', 'https://', $hls),
        'title'    => $title,
        'autor'    => $autor,
        'deletado' => $deletado
    );
}

function m18_busca_novo_proxy(){
    $json_db = new JSONDB(PASTA_DATA);

    /* Cadastra novos proxy */
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, PROXY_LINK);
    curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:7.0.1) Gecko/20100101 Firefox/7.0.12011-10-16 20:23:00");
    curl_setopt($ch, CURLOPT_ENCODING, "gzip,deflate");
    curl_setopt($ch, CURLOPT_AUTOREFERER, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION,true);

    $html = curl_exec($ch);
    curl_close($ch);

    if (!empty($html)) {
        $arr = explode(PHP_EOL, $html);
        $arr = array_filter($arr);

        set_time_limit(0);

        foreach ($arr as $itemValor) {
            $itemValor = trim($itemValor);
            $arrIP     = explode(':', $itemValor);
            $itemValor = $arrIP[0] .':'. $arrIP[1];
            
            if (preg_match('/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/', $itemValor)) {
                if(m18_is_json(PASTA_DATA .'proxy.json')){
                    $proxy_existe = $json_db->select('proxyValor')
                        ->from( 'proxy.json' )
                        ->where( [ 'proxyValor' => $itemValor] )
                        ->get();

                    if (!$proxy_existe) {
                        $json_db->insert( 'proxy.json', 
                            [ 
                                'proxyValor' => $itemValor, 
                                'proxyStatus' => 1,
                                'proxyFila' => 1,
                                'proxyAplicacoes' => 0,
                                'proxyCriadoEm' => date('Y-m-d H:i:s') 
                            ]
                        );
                    }
                }else{
                    $json_db->insert( 'proxy.json', 
                        [ 
                            'proxyValor' => $itemValor, 
                            'proxyStatus' => 1,
                            'proxyFila' => 1,
                            'proxyAplicacoes' => 0,
                            'proxyCriadoEm' => date('Y-m-d H:i:s') 
                        ]
                    );
                }
            }
        }
    }
}

function m18_is_json($string) {
    $string = @file_get_contents($string);
	json_decode($string);
	return json_last_error() === JSON_ERROR_NONE;
}

function m18_cache($cache){
    if (is_file($cache)){
        $json = file_get_contents($cache);
        $json = (array) json_decode($json, true);
        $json = array_filter($json);

        if (isset($json['tempo'])) {
            if (strtotime('now') < $json['tempo']) {
                return array(
                    'thumb'    => str_replace('http://', 'https://', $json['thumb']),
                    'mp4'      => str_replace('http://', 'https://', $json['mp4']),
                    'hls'      => str_replace('http://', 'https://', $json['hls']),
                    'title'    => $json['title'],
                    'autor'    => $json['autor'],
                    'deletado' => false
                );
            }
            unlink($cache);
        }
    }
}

function m18_conta_acesso($site, $tipo_solicitacao){
	//return true;
    if(!is_dir(PASTA_ANALYTICS)){
		mkdir(PASTA_ANALYTICS);
	}
    $json_db = new JSONDB(PASTA_ANALYTICS);
    $hoje = date('Y-m-d');
    $json = str_replace('.','-',$site) .'.json';
    if(m18_is_json(PASTA_ANALYTICS.$json)){
        $proxy_existe = $json_db->select($tipo_solicitacao)
        ->from($json)
        ->where( [ 'data' => $hoje] )
        ->get();

        if(isset($proxy_existe[0][$tipo_solicitacao])){
            $json_db->update([$tipo_solicitacao => $proxy_existe[0][$tipo_solicitacao] + 1])
                ->from($json)
                ->where( [ 'data' => $hoje] )
                ->trigger();
            return true;
        }
    }

    if(!file_exists(PASTA_ANALYTICS.$json) OR date('Hi') < 60) {
        if($tipo_solicitacao == 'novo'){
            $novo = 1;
            $existe = 0;
        }else{
            $novo = 0;
            $existe = 1;
        }
        $json_db->insert($json, 
            ['data' => $hoje, 'novo' => $novo, 'existe' => $existe]
        );
    }
}